format long;

clear all;
close all;

tic;

%%   parameters and definitions

filename = 'experiment_compare_scale_rad_p783_num_domy_6';

model = mphload(filename);
load(filename);

Eval_mech.CentralFrequency = 333e6;
Eval_mech.NumberOfFrequencies = 45;

% Path along the k-space
Eval_mech.res = 45;
Eval_mech.kx = linspace(0,pi/(geom.mech.amech),Eval_mech.res);

Eval_mech.bands = zeros(Eval_mech.NumberOfFrequencies,size(Eval_mech.kx,2));

% .mph and .mat output files
% the scripts were run 3 times for different parts, where 
% part1 contains k indices from 1 to 10
% part2 contains k indices from 11 to 20
% part3 contains k indices from 21 to 30
% Finally (not a part of this script), we combine the data values from all 
% the 3 .mat files to a single .mat file
Eval_mech.filename = strcat(filename, '_part1');

%% COMSOL STUDY

disp('Launching study... ');
study = model.study.create('std');
studyEf = study.feature.create('eig', 'Eigenfrequency');
studyEf.activate('solid', true);
studyEf.set('neigs', num2str(Eval_mech.NumberOfFrequencies));
studyEf.set('shift', num2str(Eval_mech.CentralFrequency));

for i=1:10
    disp( ['Iteration: ',num2str(i),'/',num2str(size(Eval_mech.kx,2))]  )
    model.physics('solid').feature('pc1').set('kFloquet', {num2str(Eval_mech.kx(i),'%10.9e') '0' '0'});
    study.run;
    data = mpheval(model,'freq','selection',1,'edim','point','dataonly','on');
    Eval_mech.bands(:,i) = data;

    save(Eval_mech.filename, 'Eval_mech', 'geom');

    if i>=15 && i<=19
        filename1 = strcat(Eval_mech.filename,num2str(i));
        mphsave(model, filename1);
    end
end

Eval_mech.time = toc;

save(Eval_mech.filename, 'Eval_mech', 'geom');